@extends('layouts.app')

@section('content')
<h1>Connect WhatsApp Setup</h1>

<section>
    <h2>Default Number & Business Info</h2>
    <ul>
        <li><strong>Phone Number ID:</strong> 123456789</li>
        <li><strong>Verified Name:</strong> My Business</li>
        <li><strong>Display Number:</strong> +123 456 7890</li>
        <li><strong>Quality Rating:</strong> ★★★★☆</li>
    </ul>
</section>

<section>
    <h2>Overall Health</h2>
    <ul>
        <li>WhatsApp can send message: <span style="color:green;">Yes</span></li>
        <li>App can send message: <span style="color:green;">Yes</span></li>
    </ul>
</section>

<section>
    <h2>Access Token Information</h2>
    <ul>
        <li><strong>Permission scopes:</strong> whatsapp_business_management, whatsapp_business_messaging, whatsapp_business_manage_events, public_profile</li>
        <li><strong>Issued at:</strong> Wednesday 14th May 2025 12:01:08 PM</li>
        <li><strong>Expiry at:</strong> N/A</li>
    </ul>
</section>

<section>
    <h2>WhatsApp Cloud API Setup</h2>

    <details open>
        <summary>Facebook Developer Account & Facebook App <span style="color:green;">CONFIGURED</span></summary>
        <p>App ID: 1234567890</p>
        <p>App Secret: ************</p>
    </details>

    <details open>
        <summary>Webhook Configuration <span style="color:green;">CONFIGURED</span></summary>
        <p>Webhook URL: https://example.com/webhook</p>
        <p>Verify Token: my_verify_token</p>
        <p>Callback status: Active</p>
    </details>

    <details open>
        <summary>WhatsApp Integration Setup <span style="color:green;">CONFIGURED</span></summary>
        <p>WhatsApp Phone Number linked</p>
        <p>Token valid</p>
    </details>
</section>

<section>
    <h2>Connect WhatsApp</h2>
    <button onclick="alert('OAuth flow for Facebook connect here')">Connect via Facebook</button>
    <form method="POST" action="#" style="margin-top: 1rem;">
        <label>Access Token</label><br/>
        <input type="text" name="access_token" style="width: 100%;" /><br/>
        <label>Phone Number ID</label><br/>
        <input type="text" name="phone_number_id" style="width: 100%;" /><br/>
        <label>Business Account ID</label><br/>
        <input type="text" name="business_account_id" style="width: 100%;" /><br/>
        <label>Webhook Verify Token</label><br/>
        <input type="text" name="webhook_verify_token" style="width: 100%;" /><br/>
        <button type="submit" style="margin-top: 1rem;">Save Settings</button>
    </form>
</section>

@endsection
